//{$DEFINE DEBUG}   // Uncomment this string if you want to debug plugin

library TestPlugin;

uses
  windows,
  plug in 'plug.pas';

const
  PluginName : PChar = 'Test Plugin';  // plugin name
  BenchName  : PChar = 'Plugin Bench';   // if plugin is "benchmark" plugin this const is a name for bench
  InfoName   : PChar = 'Plugin Info';   // if plugin is "info" plugin this const is a name for info

//=============================================================================
// For smaller DLL size
//=============================================================================
Function IntToStr( int : Integer ) : String;
begin
  Str(int, Result);
end;

//=============================================================================
// This functions transmite plugin's information, so main app can decide how
// to use this plugin properly
//=============================================================================
Function GetPluginInfo : TPlugunInfo;
begin
  Result.Name:= PluginName;
  Result.IsBench:= true;
  Result.IsInfo:= true;
  Result.BenchName:= BenchName;
  Result.InfoName:= InfoName;
  Result.IsUseOpenGL:= false;    // use or not default opengl window?
end;

//=============================================================================
// This proc is called from main app at load time and transmite application's
// handle.
// After that we initialize all functions, exported by main application
//=============================================================================
Procedure InitPlugin(_Owner : Cardinal);
begin
  Owner:= _Owner;
  InitializePlugin;
end;

//=============================================================================
// This Procedure calls after main window create.
// hwnd - handle of main window
//=============================================================================
Procedure PluginAfterStart(hwnd : Cardinal);
begin
  h_wnd := hwnd;

  {$IFDEF DEBUG}
  MessageBox(h_wnd, 'Plugin AfterStart', PluginName, MB_OK);
  {$ENDIF}
end;

//=============================================================================
// This Procedure calls after benchmark is started. (shift+f3 or normal start)
//=============================================================================
Procedure PluginStartBenchmark;
begin
  {$IFDEF DEBUG}
  MessageBox(h_wnd, 'Benchmark started', PluginName, MB_OK);
  {$ENDIF}
end;

//=============================================================================
// This Procedure calls in case of benchmark aborted.
//=============================================================================
Procedure PluginEndBenchmark;
begin
  {$IFDEF DEBUG}
  MessageBox(h_wnd, 'Benchmark Aborted', PluginName, MB_OK);
  {$ENDIF}
end;

//=============================================================================
// This Procedure calls in case info draws
//=============================================================================
Procedure PluginDrawInfo;
var
  PluginVersion : TplugInVersion;
begin
  PluginVersion:= beGetPluginVersion;
  {$IFDEF DEBUG}

  {$ENDIF}
  beDrawInfoText(17, 9, 10, 'Plugin API version');
  beDrawInfoText(17, 41, 10, 'Plugin API revision');
  beDrawInfoText(17, 73, 10, 'Plugin API comment');
  beDrawInfoText(17, 105, 10, 'Plugins Loaded');

  beDrawInfoText(17, 155, 9, 'This is just simple info plugin');

  beDrawInfoText(9, 25, 7, PChar(inttostr(PluginVersion.Major) + '.' + inttostr(PluginVersion.Minor)));
  beDrawInfoText(9, 57, 7, PChar(inttostr(PluginVersion.Revision)));
  beDrawInfoText(9, 89, 7, PluginVersion.Comment);
  beDrawInfoText(9, 121, 7,PChar(inttostr( PluginVersion.plugins)));
end;

//=============================================================================
// Exports Section
//=============================================================================
exports
  GetPluginInfo,     // this two procs must be exported
  InitPlugin,        // this two procs must be exported
  PluginAfterStart,
  PluginStartBenchmark,
  PluginEndBenchmark,
  PluginDrawInfo;

end.
 